/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.infernomobs.entity;

import com.google.common.base.Predicate;
import com.lycanitesmobs.ObjectManager;
import com.lycanitesmobs.api.IGroupAlpha;
import com.lycanitesmobs.api.IGroupAnimal;
import com.lycanitesmobs.api.IGroupFire;
import com.lycanitesmobs.api.IGroupPrey;
import com.lycanitesmobs.core.entity.EntityCreatureAgeable;
import com.lycanitesmobs.core.entity.EntityCreatureRideable;
import com.lycanitesmobs.core.entity.EntityItemCustom;
import com.lycanitesmobs.core.entity.ai.EntityAIAttackMelee;
import com.lycanitesmobs.core.entity.ai.EntityAIBeg;
import com.lycanitesmobs.core.entity.ai.EntityAIFollowParent;
import com.lycanitesmobs.core.entity.ai.EntityAILookIdle;
import com.lycanitesmobs.core.entity.ai.EntityAIStayByWater;
import com.lycanitesmobs.core.entity.ai.EntityAISwimming;
import com.lycanitesmobs.core.entity.ai.EntityAITargetAttack;
import com.lycanitesmobs.core.entity.ai.EntityAITargetRevenge;
import com.lycanitesmobs.core.entity.ai.EntityAITargetRiderAttack;
import com.lycanitesmobs.core.entity.ai.EntityAITargetRiderRevenge;
import com.lycanitesmobs.core.entity.ai.EntityAITempt;
import com.lycanitesmobs.core.entity.ai.EntityAIWander;
import com.lycanitesmobs.core.entity.ai.EntityAIWatchClosest;
import com.lycanitesmobs.core.info.DropRate;
import com.lycanitesmobs.core.info.MobInfo;
import com.lycanitesmobs.core.info.ObjectLists;
import java.util.HashMap;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntitySalamander
extends EntityCreatureRideable
implements IMob,
IGroupFire {
    public boolean khalkLavaDeath = true;

    public EntitySalamander(World world) {
        super(world);
        this.attribute = EnumCreatureAttribute.UNDEFINED;
        this.defense = 1;
        this.experience = 10;
        this.spawnsOnLand = true;
        this.spawnsInWater = true;
        this.isLavaCreature = true;
        this.hasAttackSound = true;
        this.hasJumpSound = true;
        this.canGrow = true;
        this.babySpawnChance = 0.01;
        this.setWidth = 2.5f;
        this.setHeight = 0.9f;
        this.solidCollision = false;
        this.setupMob();
        this.field_70138_W = 1.0f;
        this.func_184644_a(PathNodeType.LAVA, 0.0f);
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming(this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAITempt(this).setItem(new ItemStack(ObjectManager.getItem("salamandertreat"))).setTemptDistanceMin(4.0));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIAttackMelee(this).setRate(20));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIStayByWater(this).setSpeed(1.25));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIFollowParent(this).setSpeed(1.0));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWander(this).setPauseRate(30));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAIBeg(this));
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)new EntityAIWatchClosest(this).setTargetClass(EntityPlayer.class));
        this.field_70714_bg.func_75776_a(11, (EntityAIBase)new EntityAILookIdle(this));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAITargetRiderRevenge(this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAITargetRiderAttack(this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAITargetRevenge(this).setHelpCall(true));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAITargetAttack(this).setTargetClass(EntityPlayer.class));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAITargetAttack(this).setTargetClass(EntityVillager.class).setCheckSight(false));
        this.field_70715_bh.func_75776_a(4, (EntityAIBase)new EntityAITargetAttack(this).setTargetClass(IGroupPrey.class));
        this.field_70715_bh.func_75776_a(5, (EntityAIBase)new EntityAITargetAttack(this).setTargetClass(IGroupAlpha.class).setPackHuntingScale(1, 1));
        if (MobInfo.predatorsAttackAnimals) {
            this.field_70715_bh.func_75776_a(5, (EntityAIBase)new EntityAITargetAttack(this).setTargetClass(IGroupAnimal.class).setPackHuntingScale(1, 3));
            this.field_70715_bh.func_75776_a(5, (EntityAIBase)new EntityAITargetAttack(this).setTargetClass(EntityAnimal.class).setPackHuntingScale(1, 3));
        }
    }

    @Override
    protected void func_110147_ax() {
        HashMap<String, Double> baseAttributes = new HashMap<String, Double>();
        baseAttributes.put("maxHealth", 28.0);
        baseAttributes.put("movementSpeed", 0.2);
        baseAttributes.put("knockbackResistance", 0.25);
        baseAttributes.put("followRange", 16.0);
        baseAttributes.put("attackDamage", 2.0);
        super.applyEntityAttributes(baseAttributes);
    }

    @Override
    public void loadItemDrops() {
        this.drops.add(new DropRate(new ItemStack(Items.field_151044_h), 1.0f).setMaxAmount(8));
        this.drops.add(new DropRate(new ItemStack(Items.field_151064_bs), 0.75f).setMaxAmount(2));
        this.drops.add(new DropRate(new ItemStack(Items.field_151065_br), 0.5f).setMaxAmount(4));
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
    }

    @Override
    public void riderEffects(EntityLivingBase rider) {
        rider.func_70690_d(new PotionEffect(MobEffects.field_76426_n, 105, 1));
        if (rider.func_70644_a((Potion)ObjectManager.getPotionEffect("penetration"))) {
            rider.func_184589_d((Potion)ObjectManager.getPotionEffect("penetration"));
        }
        if (rider.func_70027_ad()) {
            rider.func_70066_B();
        }
    }

    @Override
    public float getAISpeedModifier() {
        if (this.lavaContact()) {
            return 2.0f;
        }
        return 1.0f;
    }

    @Override
    public float getBlockPathWeight(int x, int y, int z) {
        int waterWeight = 10;
        BlockPos pos = new BlockPos(x, y, z);
        if (this.field_70170_p.func_180495_p(pos).func_177230_c() == Blocks.field_150353_l) {
            return (super.getBlockPathWeight(x, y, z) + 1.0f) * (float)(waterWeight + 1);
        }
        if (this.field_70170_p.func_180495_p(pos).func_177230_c() == Blocks.field_150356_k) {
            return (super.getBlockPathWeight(x, y, z) + 1.0f) * (float)waterWeight;
        }
        if (this.func_70638_az() != null) {
            return super.getBlockPathWeight(x, y, z);
        }
        if (this.lavaContact()) {
            return -999999.0f;
        }
        return super.getBlockPathWeight(x, y, z);
    }

    @Override
    public boolean func_96092_aw() {
        return false;
    }

    @Override
    public double func_70042_X() {
        return (double)this.field_70131_O * 0.85;
    }

    @Override
    public boolean meleeAttack(Entity target, double damageScale) {
        if (!super.meleeAttack(target, damageScale)) {
            return false;
        }
        target.func_70015_d(this.getEffectDuration(5) / 20);
        return true;
    }

    public void specialAttack() {
        double distance = 5.0;
        List possibleTargets = this.field_70170_p.func_175647_a(EntityLivingBase.class, this.func_174813_aQ().func_72314_b(distance, distance, distance), (Predicate)new Predicate<EntityLivingBase>(){

            public boolean apply(EntityLivingBase possibleTarget) {
                return possibleTarget.func_70089_S() && possibleTarget != EntitySalamander.this && !EntitySalamander.this.func_184215_y((Entity)possibleTarget) && !EntitySalamander.this.func_184191_r((Entity)possibleTarget) && EntitySalamander.this.func_70686_a(possibleTarget.getClass()) && EntitySalamander.this.canAttackEntity(possibleTarget);
            }
        });
        if (!possibleTargets.isEmpty()) {
            for (EntityLivingBase possibleTarget : possibleTargets) {
                boolean doDamage = true;
                if (this.getRider() instanceof EntityPlayer && MinecraftForge.EVENT_BUS.post((Event)new AttackEntityEvent((EntityPlayer)this.getRider(), (Entity)possibleTarget))) {
                    doDamage = false;
                }
                if (!doDamage) continue;
                possibleTarget.func_70015_d(5);
            }
        }
        this.playAttackSound();
        this.setJustAttacked();
    }

    @Override
    public void mountAbility(Entity rider) {
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        if (this.abilityToggled) {
            return;
        }
        if (this.getStamina() < this.getStaminaCost()) {
            return;
        }
        this.specialAttack();
        this.applyStaminaCost();
    }

    @Override
    public float getStaminaCost() {
        return 15.0f;
    }

    @Override
    public int getStaminaRecoveryWarmup() {
        return 100;
    }

    @Override
    public float getStaminaRecoveryMax() {
        return 1.0f;
    }

    @Override
    public boolean shouldDismountInWater(Entity rider) {
        return false;
    }

    @Override
    public void onDismounted(Entity entity) {
        super.onDismounted(entity);
        if (entity != null && entity instanceof EntityLivingBase) {
            ((EntityLivingBase)entity).func_70690_d(new PotionEffect(MobEffects.field_76426_n, 100, 1));
        }
    }

    @Override
    public int getNoBagSize() {
        return 0;
    }

    @Override
    public int getBagSize() {
        return 10;
    }

    @Override
    public void func_70645_a(DamageSource damageSource) {
        if (!this.field_70170_p.field_72995_K && this.field_70170_p.func_82736_K().func_82766_b("mobGriefing") && this.khalkLavaDeath && !this.isTamed()) {
            int lavaWidth = (int)Math.floor(this.field_70130_N) - 1;
            int lavaHeight = (int)Math.floor(this.field_70131_O) - 1;
            for (int x = (int)this.field_70165_t - lavaWidth; x <= (int)this.field_70165_t + lavaWidth; ++x) {
                for (int y = (int)this.field_70163_u; y <= (int)this.field_70163_u + lavaHeight; ++y) {
                    for (int z = (int)this.field_70161_v - lavaWidth; z <= (int)this.field_70161_v + lavaWidth; ++z) {
                        Block block = this.field_70170_p.func_180495_p(new BlockPos(x, y, z)).func_177230_c();
                        if (block != Blocks.field_150350_a) continue;
                        IBlockState blockState = Blocks.field_150356_k.func_176203_a(11);
                        if (x == (int)this.field_70165_t && y == (int)this.field_70163_u && z == (int)this.field_70161_v) {
                            blockState = Blocks.field_150356_k.func_176203_a(12);
                        }
                        this.field_70170_p.func_180501_a(new BlockPos(x, y, z), blockState, 3);
                    }
                }
            }
        }
        super.func_70645_a(damageSource);
    }

    @Override
    public boolean func_70687_e(PotionEffect potionEffect) {
        if (ObjectManager.getPotionEffect("penetration") != null && potionEffect.func_188419_a() == ObjectManager.getPotionEffect("penetration")) {
            return false;
        }
        super.func_70687_e(potionEffect);
        return true;
    }

    @Override
    public boolean canBurn() {
        return false;
    }

    @Override
    public boolean waterDamage() {
        return true;
    }

    @Override
    public boolean func_70648_aU() {
        return true;
    }

    @Override
    public boolean canBreatheAboveWater() {
        return true;
    }

    @Override
    public float getFallResistance() {
        return 100.0f;
    }

    @Override
    public float getDamageModifier(DamageSource damageSrc) {
        if (damageSrc.func_76347_k()) {
            return 0.0f;
        }
        return super.getDamageModifier(damageSrc);
    }

    @Override
    public void applyDropEffects(EntityItemCustom entityItem) {
        entityItem.setCanBurn(false);
    }

    public float func_70013_c(float par1) {
        return 1.0f;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_70070_b(float par1) {
        return 0xF000F0;
    }

    @Override
    public EntityCreatureAgeable createChild(EntityCreatureAgeable baby) {
        return new EntitySalamander(this.field_70170_p);
    }

    @Override
    public boolean isTamingItem(ItemStack itemStack) {
        if (itemStack == null) {
            return false;
        }
        return itemStack.func_77973_b() == ObjectManager.getItem("salamandertreat");
    }

    @Override
    public boolean isHealingItem(ItemStack testStack) {
        return ObjectLists.inItemList("cookedmeat", testStack);
    }

    @Override
    public boolean petControlsEnabled() {
        return false;
    }
}

